

/**********************************************************************
  create new define obj.
**********************************************************************/

/* create form */
function createForm (formId, actionUrl, checkFun)
{
  this.id = formId;
  this.actionUrl = actionUrl;
  this.checkFun = checkFun;
  this.hiddenArr = new Array();
  this.sendArr = new Array();
  this.sendNum = 0;
  this.needSent = false;
}

/* create table */
function createTable (tableTitle, tableId)
{
  this.title = tableTitle;
  this.id = tableId;
  this.rowArr = new Array();
  this.dataArr = new Array();
}

/* create list */
function createList(listTitle, listId, dataMax)
{
  this.title = listTitle;
  this.id = listId;
  this.dataMax = dataMax;
  this.dataNum = 0;
  this.indexNum = 0;
  this.indexGroupNum = 0;
  this.indexSel = 1;
  this.titleArr = new Array();
  this.dataArr = new Array();

  if (dataMax && dataMax <= 128)
  {
    this.indexDataMax = 10;
  }
  else if (dataMax && dataMax <= 1024)
  {
    this.indexDataMax = 50;
  }
  else
  {
    this.indexDataMax = 200;
  }
}

/**********************************************************************
  draw html code.
**********************************************************************/

/* add image */
function addImage (id, src, alt)
{
  var str = '<img id="'+id+'" src="'+src+'" alt="'+alt+'" title="'+alt+'">';
  return str;
}

/* add input hidden */
function addInputHidden (id, value)
{
  var str = '<input type="hidden" name="'+id+'" id="'+id+'" value="'+value+'">';
  return str;
}

/* add input number */
function addInputNum (id, size, min, max, value)
{

  var minStr = ''+ min;
  var maxStr = ''+ max;

  if(minStr.length < maxStr.length)
  {
    var maxLength = maxStr.length;
  }
  else
  {
    var maxLength = minStr.length;
  }

  var str = '<input type="text" name="'+id+'" id="'+id+'" size="'+size+'" maxlength="'+ maxLength +'" value="'+value+'" onkeydown="parent.pressEnter(event)">';
  return str;
}

/* add input hex */
function addInputHex (id, size, max, value)
{
  var maxStr = ''+ max;
  var str = '<input type="text" name="'+id+'" id="'+id+'" size="'+size+'" maxlength="'+ maxStr.length +'" value="'+value+'" onkeydown="parent.pressEnter(event)">';
  return str;
}

/* add input ip */
function addInputIp (id, size, value)
{
  var str = '<input type="text" name="'+id+'" id="'+id+'" size="'+size+'" maxlength="15" value="'+value+'" onkeydown="parent.pressEnter(event)">';
  return str;
}

/* add input ipv6 */
function addInputIpv6 (id, size, value)
{
  var str = '<input type="text" name="'+id+'" id="'+id+'" size="'+size+'" maxlength="39" value="'+value+'" onkeydown="parent.pressEnter(event)">';
  return str;
}

/* add input ipv6 with prefix */
function addInputIpv6pre (id, size, value)
{
  var str = '<input type="text" name="'+id+'" id="'+id+'" size="'+size+'" maxlength="43" value="'+value+'" onkeydown="parent.pressEnter(event)">';
  return str;
}

/* add input ipv4/v6 */
function addInputIpBoth (id, size, value)
{
  var str = '<input type="text" name="'+id+'" id="'+id+'" size="'+size+'" maxlength="54" value="'+value+'" onkeydown="parent.pressEnter(event)">';
  return str;
}

/* add input net mask / prefix length */
function addInputMaskPrefix (id, size, value)
{
  var str = '<input type="text" name="'+id+'" id="'+id+'" size="'+size+'" maxlength="15" value="'+value+'" onkeydown="parent.pressEnter(event)">';
  return str;
}

/* add input mac */
function addInputMac (id, size, value)
{
  var str = '<input type="text" name="'+id+'" id="'+id+'" size="'+size+'" maxlength="17" value="'+value+'" onkeydown="parent.pressEnter(event)">';
  return str;
}

/* add input text */
function addInputText (id, size, max, value)
{
  var str = '<input type="text" name="'+id+'" id="'+id+'" size="'+size+'" maxlength="'+ max +'" value="'+value+'" onkeydown="parent.pressEnter(event)">';
  return str;
}

/* add input mail */
function addInputMail (id, size, max, value)
{
  var str = '<input type="text" name="'+id+'" id="'+id+'" size="'+size+'" maxlength="'+ max +'" value="'+value+'" onkeydown="parent.pressEnter(event)">';
  return str;
}

/* add input password */
function addPassword (id, size, max, value)
{
  var str = '<input type="password" name="'+id+'" id="'+id+'" size="'+size+'" maxlength="'+ max +'" value="'+value+'">';
  return str;
}

/* add select */
function addSelect (id, isMultiple, size, textOpList, valueOpList, selValue, funcName)
{
  var str = '<select name="'+id+'" id="'+id+'" size="'+size+'"';

  if (isMultiple == true)
  {
    str += ' multiple';
  }

  if (funcName)
  {
    str += ' onchange="'+ funcName +'"';
  }

  str += '>';
  var textOpArr = textOpList.split('?');
  var valueOpArr = valueOpList.split('?');

  for (var i = 0; textOpArr[i] != null; i++)
  {
    if (textOpArr[i] == '')
    {
      continue;
    }

    if (valueOpArr[i] == selValue)
    {
      str += '<option value="'+ valueOpArr[i] +'" i18n="' + textOpArr[i] + '" selected>';
    }
    else
    {
      str += '<option value="'+ valueOpArr[i] +'" i18n="' + textOpArr[i] + '">';
    }

    str += I18N.get(textOpArr[i]);
    str += '<\/option>';
  }

  str += '<\/select>';

  return str;
}

/* add select small */
function addSelectSmall (id, isMultiple, size, textOpList, valueOpList, selValue, funcName)
{
  var str = '<select class="selectSmall" name="'+id+'" id="'+id+'" size="'+size+'"';

  if (isMultiple == true)
  {
    str += ' multiple';
  }

  if (funcName)
  {
    str += ' onchange="'+ funcName +'"';
  }

  str += '>';
  var textOpArr = textOpList.split('?');
  var valueOpArr = valueOpList.split('?');

  for (var i = 0; (textOpArr[i] != null) && (textOpArr[i] != ''); i++)
  {
    if (valueOpArr[i] == selValue)
    {
      str += '<option value="'+ valueOpArr[i] +'" selected>';
    }
    else
    {
      str += '<option value="'+ valueOpArr[i] +'">';
    }

    str += textOpArr[i];
    str += '<\/option>';
  }

  str += '<\/select>';

  return str;
}

/***********************************************
 add checkbox
 note : checked     - value="1"
        not checked - value="0"
************************************************/
function addCheckBox (id, desStr, status, funcName)
{
  var str = '<input type="checkbox" name="'+id+'" id="'+id+'"';

  if (funcName)
  {
    str += ' onclick="'+ funcName +'"';
  }

  if ((status == 1) || (status == 'Enabled'))
  {
    str += ' value="1" checked>';
  }
  else
  {
    str += ' value="0">';
  }

  if (desStr != '')
  {
    str += I18N.set(desStr);
  }

  return str;
}

/***********************************************
 add radio
 note : checked     - value="1"
        not checked - value="0"
************************************************/
function addRadio (id, name, desStr, status, funcName)
{
  var str = '<input type="radio" name="'+name+'" id="'+id+'"';

  if (funcName)
  {
    str += ' onclick="'+ funcName +'"';
  }

  if (status == 1)
  {
    str += ' value="1" checked>';
  }
  else
  {
    str += ' value="0">';
  }

  if (desStr != '')
  {
    /* disable Port */
    if (desStr.replace(/&nbsp;/g, '').replace(/^[\s\xA0]+|[\s\xA0]+$/g, '') != 'Port' && desStr.search('i18n') == -1) {
      str += I18N.set(desStr);
    } else {
      str += desStr;
    }
  }

  return str;
}

/* add textarea */
function addTextarea (id, cols, rows, readonly, wrap, value)
{
  var str = '<textarea name="'+id+'" id="'+id+'" cols="'+id+'" rows="'+id+'" readonly="'+readonly+'" wrap="'+wrap+'">';
  str += value;
  str += '</textarea>';
  return str;
}

/* add extra submit button */
function addExSubmitButton (id, value, funcName)
{
  var str = '<input i18n="' + value + '" type="button" id="'+ id +'" value="'+ I18N.get(value) +'" onclick="'+ funcName +';">';
  return str;
}

/**********************************************************************
  draw common html code.
**********************************************************************/

/* draw form */
function writeForm (formId)
{
  var str = '<form name="'+ formId +'" id="'+ formId +'" method="post" action=""><\/form>';
  str += '<div id="sendSection"><\/div>';
  mainIframe.document.writeln(str);
}

/* draw action buttons */
function drawActButtons (formObjName)
{
  var str = '<div class="actButtons">';
  str += '<input class="actButton" type="button" id="applyButton" i18n="Apply" value="' + I18N.get('Apply') + '" onclick="parent.toSubmitForm(applyButton,'+formObjName+');">';
  str += '<input class="actButton" type="button" id="revertButton" i18n="Revert" value="' + I18N.get('Revert') + '" onclick="init();">';
  str += '<\/div>';
  return str;
}

/* draw delete buttons */
function drawDelButtons (formObjName)
{
  var str = '<div class="actButtons">';
  str += '<input class="actButton" type="button" id="deleteButton" i18n="Delete" value="' + I18N.get('Delete') + '" onclick="parent.toSubmitForm(deleteButton,'+formObjName+');">';
  str += '<input class="actButton" type="button" id="revertButton" i18n="Revert" value="' + I18N.get('Revert') + '"onclick="init();">';
  str += '<\/div>';
  return str;
}

/* draw clear and refresh buttons */
function drawClearAndRefreshButtons (formObjName)
{
  var str = '<div class="actButtons">';
  str += '<input class="actButton" type="button" id="clearButton" i18n="Clear" value="' + I18N.get('Clear') + '" onclick="parent.toSubmitForm(clearButton,'+ formObjName +');">';
  str += '<input class="actButton" type="button" id="refreshButton" i18n="Refresh" value="' + I18N.get('Refresh') + '" onclick="parent.window.mainIframe.location.href=parent.window.mainIframe.location.href">';
  str += '<\/div>';
  return str;
}

/* draw extra submit button */
function drawExSubmitButton (id, value, descr, formObjName)
{
  var str = '<div class="exSubmitButton" id="'+ id +'Section">';
  str += '<input type="button" id="'+ id +'" i18n="'+ value +'" value="' + I18N.get(value + '') + '" onclick="parent.toSubmitForm('+ id +','+ formObjName +');">'

  if (descr != '')
  {
    str += I18N.set(' Click this button to ');
    str += I18N.set(descr);
  }

  str += '<\/div>';
  return str;
}

/* draw clear buttons */
function drawClearButton (formObjName)
{
  var str = '<div class="actButtons">';
  str += '<input class="actButton" type="button" id="clearButton" i18n="Clear" value="' + I18N.get('Clear') + '" onclick="parent.toSubmitForm(clearButton,'+ formObjName +');">';
  str += '<\/div>';
  return str;
}

/* draw refresh button */
function drawRefreshButton ()
{
  var str = '<div class="actButtons">';
  str += '<input class="actButton" type="button" id="refreshButton" i18n="Refresh" value="' + I18N.get('Refresh') + '" onclick="parent.window.mainIframe.location.href=parent.window.mainIframe.location.href">';
  str += '<\/div>';
  return str;
}

/* draw query button */
function drawQueryButton ()
{
  var str = '<div class="actButtons">';
  str += '<input class="actButton" type="button" id="queryButton" i18n="Query" value="' + I18N.get('Query') + '" onclick="loadNew();">';
  str += '<\/div>';
  return str;
}

/* draw table*/
function drawTable (tableObj)
{
  var str = '';

  if (tableObj.title != '')
  {
    str += '<h3>'+ I18N.set(tableObj.title) +'<\/h3>';
  }

  str += '<table class="data" id="'+ tableObj.id +'">';

  /* tr loop */
  for (var k = 0; tableObj.rowArr[k] != null; k++)
  {
    str += '<tr id="'+tableObj.id+'_tr'+k+'">';

    /* td loop */
    for (var l = 0; tableObj.rowArr[k][l] != null; l++)
    {
      if (tableObj.rowArr[k][l][0][0] == 'th')
      {
        str += '<th id="'+tableObj.id+'_tr'+k+'_th'+l+'"';
        var endStr = '<\/th>';
      }
      else
      {
        str += '<td id="'+tableObj.id+'_tr'+k+'_td'+l+'"';
        var endStr = '<\/td>';
      }

      if (tableObj.rowArr[k][l][0][1] != '')
      {
        str += ' width="'+ tableObj.rowArr[k][l][0][1] +'"';
      }

      if (tableObj.rowArr[k][l][0][2] != 1)
      {
        str += ' rowspan="'+ tableObj.rowArr[k][l][0][2] +'"';
      }

      if (tableObj.rowArr[k][l][0][3] != 1)
      {
        str += ' colspan="'+ tableObj.rowArr[k][l][0][3]+'"';
      }

      str += '>';

      /* td obj loop */
      for (var m = 1; tableObj.rowArr[k][l][m] != null; m++)
      {
        /* switch type */
        switch (tableObj.rowArr[k][l][m][0])
        {
          case 'str' :
                /* str : define type, value */
                /* value */
                tableObj.rowArr[k][l][m][1] += '';
                /* DO NOT translate data */
                if (tableObj.rowArr[k][l][m][1].search('i18n') == -1 && (tableObj.rowArr[k][l][0][0] == 'th')) {
                    str += I18N.set(tableObj.rowArr[k][l][m][1]);
                }
                else {
                    if (tableObj.supportAbbreviation) {
                        str += abbreviateString(tableObj.rowArr[k][l][m][1], tableObj.abbreviationLen);
                    }
                    else {
                        str += tableObj.rowArr[k][l][m][1];
                    }
                }
                break;
          case 'inputNum' :
          case 'inputFloatNum' :
                /* input number : define type, title, obj id, must set, null vaild, size, min, max, value */
                /* obj id, size, max, value */
                str += addInputNum(tableObj.rowArr[k][l][m][2], tableObj.rowArr[k][l][m][5], tableObj.rowArr[k][l][m][6] ,tableObj.rowArr[k][l][m][7], tableObj.rowArr[k][l][m][8]);
                break;
          case 'inputHex' :
                /* input hexadecimal value : define type, title, obj id, must set, null vaild, size, min, max, value */
                /* obj id, size, max, value */
                str += addInputHex(tableObj.rowArr[k][l][m][2], tableObj.rowArr[k][l][m][5], tableObj.rowArr[k][l][m][7], tableObj.rowArr[k][l][m][8]);
                break;
          case 'inputIp' :
                /* input ip : define type, title, obj id, must set, null vaild, size, value */
                /* obj id, size, value */
                str += addInputIp(tableObj.rowArr[k][l][m][2], tableObj.rowArr[k][l][m][5], tableObj.rowArr[k][l][m][6]);
                break;
          case 'inputIpv6' :
                /* input ipv6 : define type, title, obj id, must set, null vaild, size, value */
                /* obj id, size, value */
                str += addInputIpv6(tableObj.rowArr[k][l][m][2], tableObj.rowArr[k][l][m][5], tableObj.rowArr[k][l][m][6]);
                break;
          case 'inputIpv6pre' :
                /* input ipv6 with prefix : define type, title, obj id, must set, null vaild, size, value */
                /* obj id, size, value */
                str += addInputIpv6pre(tableObj.rowArr[k][l][m][2], tableObj.rowArr[k][l][m][5], tableObj.rowArr[k][l][m][6]);
                break;
          case 'inputIpBoth' :
                /* input ipv4/v6 : define type, title, obj id, must set, null vaild, size, value */
                /* obj id, size, value */
                str += addInputIpBoth(tableObj.rowArr[k][l][m][2], tableObj.rowArr[k][l][m][5], tableObj.rowArr[k][l][m][6]);
                break;
          case 'inputMaskPrefix' :
                /* input net mask / prefix length : define type, title, obj id, must set, null vaild, size, value */
                /* obj id, size, value */
                str += addInputMaskPrefix(tableObj.rowArr[k][l][m][2], tableObj.rowArr[k][l][m][5], tableObj.rowArr[k][l][m][6]);
                break;
          case 'inputMac' :
                /* input mac : define type, title, obj id, must set, null vaild, size, value */
                /* obj id, size, value */
                str += addInputMac(tableObj.rowArr[k][l][m][2], tableObj.rowArr[k][l][m][5], tableObj.rowArr[k][l][m][6]);
                break;
          case 'inputText' :
                /* input text : define type, title, obj id, must set, space vaild, size, min, max, value */
                /* obj id, size, max, value */
                str += addInputText(tableObj.rowArr[k][l][m][2], tableObj.rowArr[k][l][m][5], tableObj.rowArr[k][l][m][7], tableObj.rowArr[k][l][m][8]);
                break;
          case 'inputMail' :
                /* input email : define type, title, obj id, must set, space vaild, size, min, max, value */
                /* obj id, size, max, value */
                str += addInputMail(tableObj.rowArr[k][l][m][2], tableObj.rowArr[k][l][m][5], tableObj.rowArr[k][l][m][7], tableObj.rowArr[k][l][m][8]);
                break;
          case 'password' :
          case 'singlePassword' :
                /* password : define type, title, obj id, must set, space vaild, size, min, max, value */
                /* obj id, size, max, value */
                str += addPassword(tableObj.rowArr[k][l][m][2], tableObj.rowArr[k][l][m][5], tableObj.rowArr[k][l][m][7], tableObj.rowArr[k][l][m][8]);
                break;
          case 'select' :
                /* select : define type, title, obj id, must set, is multiple, size, text option list, value option list, selected value, funtion name */
                /* obj id, is multiple, size, text option list, value option list, selected value, funtion name */
                str += addSelect(tableObj.rowArr[k][l][m][2], tableObj.rowArr[k][l][m][4], tableObj.rowArr[k][l][m][5], tableObj.rowArr[k][l][m][6], tableObj.rowArr[k][l][m][7], tableObj.rowArr[k][l][m][8], tableObj.rowArr[k][l][m][9]);
                break;
          case 'checkBox' :
                /* checkBox : define type, title, obj id, must set, description string, status, funtion name */
                /* obj id, description string, status, funtion name */
                str += addCheckBox(tableObj.rowArr[k][l][m][2], tableObj.rowArr[k][l][m][4], tableObj.rowArr[k][l][m][5], tableObj.rowArr[k][l][m][6]);
                break;
          case 'radio' :
                /* radio : define type, title, obj id, obj name, must set, description string, status, funtion name */
                /* obj id, obj name, description string, status, funtion name */
                str += addRadio(tableObj.rowArr[k][l][m][2], tableObj.rowArr[k][l][m][3], tableObj.rowArr[k][l][m][5], tableObj.rowArr[k][l][m][6], tableObj.rowArr[k][l][m][7]);
                break;
        }
      }

      str += endStr;
    }

    str += '<\/tr>';
  }

  str += '<\/table>';
  return str;
}

/* add list index */
function addListIndex (listObj)
{
  listObj.indexNum = (listObj.dataNum % listObj.indexDataMax > 0) ? Math.floor(listObj.dataNum / listObj.indexDataMax) + 1 : listObj.dataNum / listObj.indexDataMax;
  listObj.indexGroupNum = (listObj.indexNum % 10 > 0) ? Math.floor(listObj.indexNum / 10) + 1 : listObj.indexNum / 10;

  var str = '';

  if (listObj.indexNum > 1)
  {
    for (var i = 1; i <= listObj.indexGroupNum; i++)
    {
      str += '<div class="listIndex" id="'+ listObj.id +'IndexGroup'+ i +'">';

      if (i != 1)
      {
        str += '<img id="'+ listObj.id +'IndexBack'+ i +'" src="../images/'+ oemName +'/index_back.gif" alt="Back" title="Back" onmouseover="parent.overListIndex(this);" onmouseout="parent.outListIndex(this);" onclick="parent.showList('+ listObj.id +'Obj, '+ (i-1) +');">';
      }

      for (var j = (i-1)*10+1; (j <= (i-1)*10+10) && (j <= listObj.indexNum); j++)
      {
        str += '<span id="'+ listObj.id +'Index'+ j +'" onmouseover="parent.overListIndex(this);" onmouseout="parent.outListIndex(this);" onclick="parent.showListPage('+ listObj.id +'Obj, '+ j +');">'+ j +'<\/span>';

      }

      if (i < listObj.indexGroupNum)
      {
        str += '<img id="'+ listObj.id +'IndexDown'+ i +'" src="../images/'+ oemName +'/index_next.gif" alt="Next" title="Next" onmouseover="parent.overListIndex(this);" onmouseout="parent.outListIndex(this);" onclick="parent.showList('+ listObj.id +'Obj, '+ (i+1)  +');">';
      }

      str += '<\/div>';
    }
  }

  return str;
}

/* draw list title */
function drawListTitle (listObj, listType, indexNum)
{
  var str = '';

  /* titleArr tr loop */
  for (var k = 0; listObj.titleArr[k] != null; k++)
  {
    str += '<tr>';

    if ((listType == 'delete') && (k == 0))
    {
      if (listObj.titleArr[1] != null)
      {
        str += '<th width="5%" rowspan="2">';

      }
      else
      {
        str += '<th width="5%">';
      }

      str += addCheckBox('allChk'+indexNum, '', 0, 'parent.listAllChg(this, ' + listObj.indexNum + ', ' + listObj.dataNum + ')');
      str += '<\/th>';
    }

    if ((listType == 'radioSel') && (k == 0))
    {
      if (listObj.titleArr[1] != null)
      {
        str += '<th width="5%" rowspan="2"><\/th>';

      }
      else
      {
        str += '<th width="5%"><\/th>';
      }
    }

    if ((listType == 'clear') && (k == 0))
    {
      if (listObj.titleArr[1] != null)
      {
        str += '<th width="5%" rowspan="3">';

      }
      else
      {
        str += '<th width="5%">';
      }

      str += addCheckBox('allChk'+indexNum, '', 0, 'parent.listAllChg(this, ' + listObj.indexNum + ', ' + listObj.dataNum + ')');
      str += '<\/th>';
    }

    /* title loop */
    for (var l = 0; listObj.titleArr[k][l] != null; l++)
    {
      str += '<th';

      if (listObj.titleArr[k][l][0][0] != '')
      {
        str += ' width="'+ listObj.titleArr[k][l][0][0] +'"';
      }
      else if (listObj.titleArr[k][l][0][1] != 1)
      {
        str += ' rowspan="'+ listObj.titleArr[k][l][0][1] +'"';
      }
      else if (listObj.titleArr[k][l][0][2] != 1)
      {
        str += ' colspan="'+ listObj.titleArr[k][l][0][2]+'"';
      }

      listObj.titleArr[k][l][1][1] += '';
      if (listObj.titleArr[k][l][1][1].search('i18n') == -1) {
        str += '>'+ I18N.set(listObj.titleArr[k][l][1][1]) +'<\/th>';
      } else {
        str += '>'+ listObj.titleArr[k][l][1][1] +'<\/th>';
      }
    }

    str += '<\/tr>';
  }

  return str;
}

/* draw list */
function drawList (listObj, listType)
{
  var str = '<div class="listSection" id="'+ listObj.id +'">';
  str += '<h4>'+ I18N.set(listObj.title) +'<\/h4>';

  if (listObj.assignedDataNum) {
    str += '<span class="note">' + I18N.set('Total: ') + listObj.assignedDataNum +'<\/span>';
  }
  else {
    str += '<span class="note">' + I18N.set('Total: ') + listObj.dataNum +'<\/span>';
  }

  str += addListIndex(listObj);

  if (listType == 'null')
  {
    str += '<table class="list">';
    str += drawListTitle(listObj, listType);
    str += '<\/table>';
  }
  else if (listType == 'info')
  {
    for (var i = 1; i <= listObj.indexNum; i++)
    {
      str += '<div id="'+ listObj.id +'Section'+ i +'">';
      str += '<table class="list">';
      str += drawListTitle(listObj, 'info');

      /* data indexDataMax loop */
      for (var j = 0; j < listObj.indexDataMax; j++)
      {
        var dataNum = j + (i - 1) * listObj.indexDataMax;

        if (listObj.dataArr[dataNum] != null)
        {
          var innArr = listObj.dataArr[dataNum].split('?');

          str += '<tr>';

          /* td loop */
          for (var n = 0; innArr[n] != null; n++)
          {
            str += '<td>'+ innArr[n] +'<\/td>';
          }

          str += '<\/tr>';
        }
      }

      str += '<\/table><\/div>';
    }
  }
  else if (listType == 'delete')
  {
    for (var i = 1; i <= listObj.indexNum; i++)
    {
      str += '<div id="'+ listObj.id +'Section'+ i +'">';
      str += '<table class="list">';
      str += drawListTitle(listObj, 'delete', i);

      /* data indexDataMax loop */
      for (var j = 0; j < listObj.indexDataMax; j++)
      {
        var dataNum = j + (i - 1) * listObj.indexDataMax;

        if (listObj.dataArr[dataNum] != null)
        {
          var innArr = listObj.dataArr[dataNum].split('?');

          str += '<tr>';
          str += '<td>'+ addCheckBox('chk'+dataNum, '', 0, 'parent.listChkChg(this, ' + listObj.indexNum + ')') +'<\/td>';

          /* td loop */
          for (var n = 0; innArr[n] != null; n++)
          {
            str += '<td>'+ innArr[n] +'<\/td>';
          }

          str += '<\/tr>';
        }
      }

      str += '<\/table><\/div>';
    }
  }
  else if (listType == 'clear')
  {
    for (var i = 1; i <= listObj.indexNum; i++)
    {
      str += '<div id="'+ listObj.id +'Section'+ i +'">';
      str += '<table class="list">';
      str += drawListTitle(listObj, 'clear', i);

      /* data indexDataMax loop */
      for (var j = 0; j < listObj.indexDataMax; j++)
      {
        var dataNum = j + (i - 1) * listObj.indexDataMax;

        if (listObj.dataArr[dataNum] != null)
        {
          var innArr = listObj.dataArr[dataNum].split('?');

          str += '<tr>';
          str += '<td>'+ addCheckBox('chk'+dataNum, '', 0, 'parent.listChkChg(this, ' + listObj.indexNum + ')') +'<\/td>';

          /* td loop */
          for (var n = 0; innArr[n] != null; n++)
          {
            str += '<td>'+ innArr[n] +'<\/td>';
          }

          str += '<\/tr>';
        }
      }

      str += '<\/table><\/div>';
    }
  }
  else if (listType == 'radioSel')
  {
    for (var i = 1; i <= listObj.indexNum; i++)
    {
      str += '<div id="'+ listObj.id +'Section'+ i +'">';
      str += '<table class="list">';
      str += drawListTitle(listObj, 'radioSel');

      /* data indexDataMax loop */
      for (var j = 0; j < listObj.indexDataMax; j++)
      {
        var dataNum = j + (i - 1) * listObj.indexDataMax;

        if (listObj.dataArr[dataNum] != null)
        {
          var innArr = listObj.dataArr[dataNum].split('?');

          str += '<tr>';
          str += '<td>'+ addRadio('chk'+dataNum, 'chk', '', 0) +'<\/td>';

          /* td loop */
          for (var n = 0; innArr[n] != null; n++)
          {
            str += '<td>'+ innArr[n] +'<\/td>';
          }

          str += '<\/tr>';
        }
      }

      str += '<\/table><\/div>';
    }
  }
  else if (listType == 'delete detail')
  {
    for (var i = 1; i <= listObj.indexNum; i++)
    {
      str += '<div id="'+ listObj.id +'Section'+ i +'">';
      str += '<table class="list">';
      str += drawListTitle(listObj, 'delete');

      /* data indexDataMax loop */
      for (var j = 0; j < listObj.indexDataMax; j++)
      {
        var dataNum = j + (i - 1) * listObj.indexDataMax;

        if (listObj.dataArr[dataNum] != null)
        {
          var innArr = listObj.dataArr[dataNum].split('?');

          str += '<tr>';
          str += '<td>'+ addCheckBox('chk'+dataNum, '', 0, 'parent.listChkChg(this, ' + listObj.indexNum + ')') +'<\/td>';

          /* td loop */
          for (var n = 0; innArr[n] != null; n++)
          {
            str += '<td>'+ innArr[n] +'<\/td>';
          }

          /* detail td */
          str += '<td><img id="editImg" src="../images/edit.gif" alt="Edit Rule" title="Edit Rule" onmouseover="showDetail();"><\/td>';

          str += '<\/tr>';
        }
      }

      str += '<\/table><\/div>';
    }
  }
  else
  {
    var dataIndex = 0;

    /* index loop */
    for (var i = 1; i <= listObj.indexNum; i++)
    {
      str += '<div id="'+ listObj.id +'Section'+ i +'">';
      str += '<table class="list">';
      str += drawListTitle(listObj, 'config');

      /* index data max loop */
      for (var j = 0; (j < listObj.indexDataMax) && (dataIndex <= listObj.dataNum); j++, dataIndex++)
      {
        if (listObj.dataArr[dataIndex])
        {
          /* dataArr tr loop */
          for (var k = 0; listObj.dataArr[dataIndex][k] != null; k++)
          {
            str += '<tr>';

            /* td loop */
            for (var l = 0; listObj.dataArr[dataIndex][k][l] != null; l++)
            {
              str += '<td';

              if (listObj.dataArr[dataIndex][k][l][0][0] != '')
              {
                str += ' width="'+ listObj.dataArr[dataIndex][k][l][0][0] +'"';
              }
              else if (listObj.dataArr[dataIndex][k][l][0][1] != 1)
              {
                str += ' rowspan="'+ listObj.dataArr[dataIndex][k][l][0][1] +'"';
              }
              else if (listObj.dataArr[dataIndex][k][l][0][2] != 1)
              {
                str += ' colspan="'+ listObj.dataArr[dataIndex][k][l][0][2]+'"';
              }

              str += '>';

              /* td obj loop */
              for (var m = 1; listObj.dataArr[dataIndex][k][l][m] != null; m++)
              {
                /* switch type */
                switch (listObj.dataArr[dataIndex][k][l][m][0])
                {
                  case 'str' :
                        /* str : define type, value */
                        /* value */
                        str += listObj.dataArr[dataIndex][k][l][m][1];
                        break;
                  case 'inputNum' :
                  case 'inputFloatNum' :
                        /* input number : define type, title, obj id, must set, null vaild, size, min, max, value */
                        /* obj id, size, max, value */
                        str += addInputNum(listObj.dataArr[dataIndex][k][l][m][2], listObj.dataArr[dataIndex][k][l][m][5], listObj.dataArr[dataIndex][k][l][m][6], listObj.dataArr[dataIndex][k][l][m][7], listObj.dataArr[dataIndex][k][l][m][8]);
                        break;
                  case 'inputHex' :
                        /* input hexadecimal value : define type, title, obj id, must set, null vaild, size, min, max, value */
                        /* obj id, size, max, value */
                        str += addInputHex(listObj.dataArr[dataIndex][k][l][m][2], listObj.dataArr[dataIndex][k][l][m][5], listObj.dataArr[dataIndex][k][l][m][7], listObj.dataArr[dataIndex][k][l][m][8]);
                        break;
                  case 'inputIp' :
                        /* input ip : define type, title, obj id, must set, size, value */
                        /* obj id, size, value */
                        str += addInputIp(listObj.dataArr[dataIndex][k][l][m][2], listObj.dataArr[dataIndex][k][l][m][5], listObj.dataArr[dataIndex][k][l][m][6]);
                        break;
                  case 'inputIpv6' :
                        /* input ipv6 : define type, title, obj id, must set, size, value */
                        /* obj id, size, value */
                        str += addInputIpv6(listObj.dataArr[dataIndex][k][l][m][2], listObj.dataArr[dataIndex][k][l][m][5], listObj.dataArr[dataIndex][k][l][m][6]);
                        break;
                  case 'inputIpv6pre' :
                        /* input ipv6 with prefix : define type, title, obj id, must set, size, value */
                        /* obj id, size, value */
                        str += addInputIpv6pre(listObj.dataArr[dataIndex][k][l][m][2], listObj.dataArr[dataIndex][k][l][m][5], listObj.dataArr[dataIndex][k][l][m][6]);
                        break;
                  case 'inputIpBoth' :
                        /* input ipv4/v6 : define type, title, obj id, must set, size, value */
                        /* obj id, size, value */
                        str += addInputIpBoth(listObj.dataArr[dataIndex][k][l][m][2], listObj.dataArr[dataIndex][k][l][m][5], listObj.dataArr[dataIndex][k][l][m][6]);
                        break;
                  case 'inputMaskPrefix' :
                        /* input net mask / prefix length : define type, title, obj id, must set, size, value */
                        /* obj id, size, value */
                        str += addInputMaskPrefix(listObj.dataArr[dataIndex][k][l][m][2], listObj.dataArr[dataIndex][k][l][m][5], listObj.dataArr[dataIndex][k][l][m][6]);
                        break;
                  case 'inputText' :
                        /* input text : define type, title, obj id, must set, space vaild, size, min, max, value */
                        /* obj id, size, max, value */
                        str += addInputText(listObj.dataArr[dataIndex][k][l][m][2], listObj.dataArr[dataIndex][k][l][m][5], listObj.dataArr[dataIndex][k][l][m][7], listObj.dataArr[dataIndex][k][l][m][8]);
                        break;
                  case 'password' :
                  case 'singlePassword' :
                        /* password : define type, title, obj id, must set, space vaild, size, min, max, value */
                        /* obj id, size, max, value */
                        str += addPassword(listObj.dataArr[dataIndex][k][l][m][2], listObj.dataArr[dataIndex][k][l][m][5], listObj.dataArr[dataIndex][k][l][m][7], listObj.dataArr[dataIndex][k][l][m][8]);
                        break;
                  case 'selectSmall' :
                        /* select : define type, title, obj id, must set, is multiple, size, text option list, value option list, selected value, funtion name */
                        /* obj id, is multiple, size, text option list, value option list, selected value, funtion name */
                        str += addSelectSmall(listObj.dataArr[dataIndex][k][l][m][2], listObj.dataArr[dataIndex][k][l][m][4], listObj.dataArr[dataIndex][k][l][m][5], listObj.dataArr[dataIndex][k][l][m][6], listObj.dataArr[dataIndex][k][l][m][7], listObj.dataArr[dataIndex][k][l][m][8], listObj.dataArr[dataIndex][k][l][m][9]);
                        break;
                  case 'select' :
                        /* select : define type, title, obj id, must set, is multiple, size, text option list, value option list, selected value, funtion name */
                        /* obj id, is multiple, size, text option list, value option list, selected value, funtion name */
                        str += addSelect(listObj.dataArr[dataIndex][k][l][m][2], listObj.dataArr[dataIndex][k][l][m][4], listObj.dataArr[dataIndex][k][l][m][5], listObj.dataArr[dataIndex][k][l][m][6], listObj.dataArr[dataIndex][k][l][m][7], listObj.dataArr[dataIndex][k][l][m][8], listObj.dataArr[dataIndex][k][l][m][9]);
                        break;
                  case 'checkBox' :
                        /* checkBox : define type, title, obj id, must set, description string, status */
                        /* obj id, description string, status, funtion name */
                        str += addCheckBox(listObj.dataArr[dataIndex][k][l][m][2], listObj.dataArr[dataIndex][k][l][m][4], listObj.dataArr[dataIndex][k][l][m][5], listObj.dataArr[dataIndex][k][l][m][6]);
                        break;
                  case 'radio' :
                        /* radio : define type, title, obj id, obj name, must set, description string, status, funtion name */
                        /* obj id, obj name, description string, status, funtion name */
                        str += addRadio(listObj.dataArr[dataIndex][k][l][m][2], listObj.dataArr[dataIndex][k][l][m][3], listObj.dataArr[dataIndex][k][l][m][5], listObj.dataArr[dataIndex][k][l][m][6], listObj.dataArr[dataIndex][k][l][m][7]);
                        break;
                  case 'button' :
                        /* button : define type, title, obj id, obj value, funtion name */
                        /* obj id, obj value, form obj name */
                        str += addExSubmitButton(listObj.dataArr[dataIndex][k][l][m][2], listObj.dataArr[dataIndex][k][l][m][3], listObj.dataArr[dataIndex][k][l][m][4]);
                        break;
                }
              }

              str += '<\/td>';
            }

            str += '<\/tr>';
          }
        }
      }

      str += '<\/table><\/div>';
    }
  }

  str += '<\/div>';
  return str;
}

/* draw index content section*/
function drawIndexContent (indexObj, contentId)
{
  var str = drawTable(indexObj);
  str += '<div id="'+contentId+'"><\/div>';
  return str;
}

/**********************************************************************
  common funtion.
**********************************************************************/

/**
 * @description Link mainIframe to page corresponds to action.
 */
function actChanged () {
    actDisable(true);

    if (typeof MYAPP !== 'undefined') {
        var utility = MYAPP.utility,
            assert = utility.assert,
            scheme = MYAPP.scheme,
            query,
            url,
            stepSel = document.getElementById("stepSel"),
            actSel = document.getElementById('actSel');

        query = {
            parameters: {
                unit: document.getElementById('unitSel').value
            }
        };

        query.sidebar = MYAPP.sidebar;

        if (stepSel) {
            query.step = stepSel.value;
        }

        if (actSel) {
            query.action = actSel.value;
        }

        url = utility.getTransferUrl(scheme, query);

        if (url.match(/transfer.htm/)) {
            MYAPP.actTransferUrl = 'home/' + url;
        }
        else {
            MYAPP.actTransferUrl = 'config/' + url;
        }

        mainIframe.location.href = MYAPP.actTransferUrl;
    }
    else {
        mainIframe.init();
    }
}

/* FUNCTION NAME: actDisable
 * PURPOSE: enable or disable action button.
 * INPUT  : status - true or false
 * OUTPUT : none
 * RETURN : none
 * NOTE   : none
 */
function actDisable (status)
{
  var obj = document.getElementById('actSel');

  if (obj)
  {
    obj.disabled = status;
  }
}

/* submit form */
function toSubmitForm (buttonObj, formObj)
{
  var MAX_REQS = formObj.MAX_REQS || 50;
  var allReqs;

  if (formObj.checkFun != null)
  {
    var checkFunStr = "mainIframe."+ formObj.checkFun;

    if (!eval(checkFunStr))
    {
        return;
    }
  }

  var dataNum = getDataNum(formObj);
  if (dataNum && MAX_REQS < dataNum[1]) {
    allReqs = separateRequest(formObj);
  }

  if (allReqs && allReqs.length !== 0) {
    $(allReqs).each(function (i) {
      formObj.sendArr = this.sendArr;
      formObj.sendNum = this.sendArr.length;
      
      var dataNum = getDataNum(formObj);
      if (dataNum) {
        dataNum[1] = this.dataNum;
      }

      if (i < allReqs.length - 1) {
        send(formObj);
      } else {
        sendAndRefreshPage(buttonObj, formObj);
      }
    });
  } else {
    sendAndRefreshPage(buttonObj, formObj);
  }

  function separateRequest(formObj) {
    var reqs = [],
        error;

    $.each(formObj.sendArr, function() {
      var found = this[0].match(/(\w+?)(\d+)$/),
          idx,
          req;

      if (found) {
        idx = found[2];

        if (typeof reqs[idx] === 'undefined') {
          reqs[idx] = {};
        }

        req = reqs[idx];
        req[found[1]] = this;
      } else {
        console.error('not match ' + this);
        error = true;
      }
    });

    if (error) {
      return;
    }

    return $.reduce(reqs, function (allReqs, req, index) {
      if (allReqs.length === 0) {
        allReqs.push({
          dataNum:0,
          sendArr: []
        })
      }

      var el = allReqs[allReqs.length - 1];
      if (MAX_REQS <= el.dataNum) {
        allReqs.push({
          dataNum:0,
          sendArr: []
        })
        el = allReqs[allReqs.length - 1];
      }

      $.each(req, function (key, value) {
        el.sendArr.push([key + el.dataNum, value[1]]);
      });

      el.dataNum += 1;
      return allReqs;
    }, []);
  }

  function getDataNum(formObj) {
    var el;

    $.each(formObj.hiddenArr, function () {
      if ($.isArray(this)) {
        if (this[0] === 'dataNum') {
          el = this;
          return false;
        }
      }
    });

    return el;
  }

  function send(formObj) {
    var str = '<form name="'+ formObj.id +'" id="'+ formObj.id +'" method="post" action="'+ formObj.actionUrl +'">';

    for (var i = 0; formObj.hiddenArr[i] != null; i++)
    {
      str += addInputHidden(formObj.hiddenArr[i][0], Quot2Esc(formObj.hiddenArr[i][1]));
    }

    for (var i = 0; i < formObj.sendNum; i++)
    {
      str += addInputHidden(formObj.sendArr[i][0], Quot2Esc(formObj.sendArr[i][1]));
    }

    str += '<\/form>';

    $.ajax({	  
      type:"POST",
      url: '/config/' + formObj.actionUrl,
      data: $('<div/>').html(str).contents().serialize(),
      dataType: "json",	
      async: false,
      contentType: "application/json",
      success: function(data)
      {
        //console.log('send ' + str + ' success');
      },
      error: function(jqXHR, textStatus, errorThrown) 
      {
/*--#FAKE*/
        $('#result').html('<p>status code: '+jqXHR.status+'</p><p>errorThrown: ' + errorThrown + '</p><p>jqXHR.responseText:</p><div>'+jqXHR.responseText + '</div>');
        console.log('jqXHR:');
        console.log(jqXHR);
        console.log('textStatus:');
        console.log(textStatus);
        console.log('errorThrown:');
        console.log(errorThrown);
/*--#ENDFAKE*/
       },
    });
  }

  function sendAndRefreshPage(buttonObj, formObj) {
    var str = '<form name="'+ formObj.id +'" id="'+ formObj.id +'" method="post" action="'+ formObj.actionUrl +'">';

    for (var i = 0; formObj.hiddenArr[i] != null; i++)
    {
      str += addInputHidden(formObj.hiddenArr[i][0], Quot2Esc(formObj.hiddenArr[i][1]));
    }

    for (var i = 0; i < formObj.sendNum; i++)
    {
      str += addInputHidden(formObj.sendArr[i][0], Quot2Esc(formObj.sendArr[i][1]));
    }

    str += '<\/form>';
    mainIframe.document.getElementById('sendSection').innerHTML = str;
    if (buttonObj != null)
    {
      buttonObj.disabled = true;
    }
/*--#FAKE*/
    alert(str);
/*--#ENDFAKE*/
    mainIframe.document.getElementById(formObj.id).submit();
  }
}

function overListIndex (obj)
{
  obj.style.cursor = "pointer";
}

function outListIndex (obj)
{
  document.body.style.cursor = "default";
}

/* show list */
function showList (listObj, indexGroup)
{
  if (listObj.indexNum > 1)
  {
    for (var i = 1; i <= listObj.indexGroupNum; i++)
    {
      mainIframe.document.getElementById(listObj.id +'IndexGroup'+ i).style.display = 'none';
    }

    mainIframe.document.getElementById(listObj.id +'IndexGroup'+ indexGroup).style.display = "block";
  }

  if (listObj.dataNum > 0)
  {
  showListPage(listObj, (indexGroup-1)*10+1);
}
}

/* show list page */
function showListPage (listObj, index)
{
  if (index != listObj.indexSel)
  {
    mainIframe.document.getElementById(listObj.id +'Index'+ listObj.indexSel).style.background = "#FFF";
  }

  if (listObj.indexNum != 1)
  {
    listObj.indexSel = index;
    mainIframe.document.getElementById(listObj.id +'Index'+ index).style.background = "yellow";
    disList (listObj, "none");
    mainIframe.document.getElementById(listObj.id +'Section'+ index).style.display = "block";
  }
}

/* display list */
function disList (listObj, disType)
{
  for (var i = 1; i <= listObj.indexNum; i++)
  {
    mainIframe.document.getElementById(listObj.id +'Section'+ i).style.display = disType;
  }
}

/* search list obj match data */
function searchData (listObj, index, innIndex)
{
  var dataArr = new Array();

  for (var dataNum = 0; dataNum < listObj.dataNum; dataNum++)
  {
    if (listObj.dataArr[dataNum])
    {
      var innArr = listObj.dataArr[dataNum].split('?');

      if (Esc2Str(innArr[innIndex]) == index)
      {
        dataArr = listObj.dataArr[dataNum];
        break;
      }
    }
  }

  return Esc2Str(dataArr);
}

/* init form */
function clearFormSendArr (formObj)
{
  formObj.sendArr = new Array();
  formObj.sendNum = 0;
  formObj.needSent = false;
}

/* get option list from data temp */
function getOpListFromTemp (tempNum, tempArr)
{
  var opStr = '';

  if (tempArr[0])
  {
    opStr += tempArr[0];
  }

  for (var i = 1; i < tempNum; i++)
  {
    if (tempArr[i])
    {
      opStr += '?'+ tempArr[i];
    }
  }

  return opStr;
}

/* change object checked status */
function objChecked (id, status)
{
  var obj = mainIframe.document.getElementById(id);

  if (obj)
  {
    if ((status == true) || (status == 1) || (status == 'Enabled'))
    {
      obj.checked = true;
    }
    else
    {
      obj.checked = false;
    }
  }
}

/* change object disabled status */
function objDisabled (id, disabled)
{
  var obj = mainIframe.document.getElementById(id);

  if (obj)
    obj.disabled = disabled;
}

/* change object display status */
function objDisplay (id, status)
{
  var obj = mainIframe.document.getElementById(id);

  if (obj)
  {
    if (status == "table-row" || status == "table")
    {
       /* IE */
       if (navigator.appName == "Microsoft Internet Explorer")
       {
         obj.style.display = 'block';
       }
       /* Other browser */
       else
       {
         obj.style.display = status;
       }
    }
    else
    {
      obj.style.display = status;
    }
  }
}

/* change all list check status */
function listAllChg (obj, indexNum, dataNum)
{
  var status, i;
  if (obj.checked == true)
  {
    status = true;
  }
  else
  {
    status = false;
  }

  for (i = 1; i <= indexNum; i++)
  {
    objChecked('allChk'+i, status);
  }

  for (i = 0; i < dataNum; i++)
  {
    objChecked('chk'+i, status);
  }
}

/* swap image */
function swapImg(obj, imgUrl)
{
  if (obj)
  {
    obj.src = imgUrl;
  }
}

function pressEnter(e)
{
  e = e || window.event;
  var keynum = e.which || e.charCode || e.keyCode;
  var enterKeyNum = 13;

  if (keynum == enterKeyNum)
  {
    if (e.preventDefault)
      e.preventDefault();

    e.returnValue = false;

    if (e.stopPropagation)
      e.stopPropagation();

    e.cancelBubble = false;
    return false;
  }
  return true;
}

/*--#FAKE--*/
var cpntPortGigaphy = parent.cpntPortGigaphy;
/*--#ENDFAKE--*/
/*--#REAL
var cpntPortGigaphy = #cpntPortGigaphy#;
*//*#ENDREAL*/

/**
 * Get port properties which related to port type.
 * @param {string} type The port type.
 * @return {obj} An object contain all properties of port, the properties are as following:
 *     obj.displayType              {string}   -The port type display on Web
 *     obj.speedDpxOpList           (string)   -Speed duplex which are supported.
 *     obj.autonegStatusChecked     (boolean)  -If autonegotiation status is must be enabled, it will be true.
 *     obj.autonegStatusDisabled    (boolean)  -Autonegotiation status is supported.
 *     obj.autonegCapaSpeedAllArr   (string[]) -Supported autonegotiation speed capabilities on system.
 *     obj.autonegCapaSpeedArr      (string[]) -Supported autonegotiation speed capabilities of this type.
 *     obj.autonegCapa10hDisabled   (boolean)  -The supporting of autonegotiation capability.
 *     obj.autonegCapa10fDisabled   (boolean)
 *     obj.autonegCapa100hDisabled  (boolean)
 *     obj.autonegCapa100fDisabled  (boolean)
 *     obj.autonegCapa1000hDisabled (boolean)
 *     obj.autonegCapa1000fDisabled (boolean)
 *     obj.autonegCapa10GhDisabled  (boolean)
 *     obj.autonegCapa10GfDisabled  (boolean)
 *     obj.autonegCapa40GhDisabled  (boolean)
 *     obj.autonegCapa40GfDisabled  (boolean)
 *     obj.autonegCapaSymDisabled   (boolean)
 *     obj.autonegCapaFCDisabled    (boolean)
 *     obj.rateLimitMax             (number)   -Rate limit maxmun value.
 *     obj.stormRateMax             (number)   -Storm rate maxmun value.
 *     obj.powerSaveStatusDisabled  (boolean)  -Support of power save.
 */
function getPortPropertyAs(type)
{
  var obj = {};
  obj.autonegCapaSpeedAllArr = new Array("10h","10f","100h","100f","1000h","1000f","10Gh","10Gf","40Gh","40Gf");

  /* for every type */
  switch (type)
  {
    case '100Base-TX':
        obj.displayType = '100BASE-TX';
        break;
    case '100Base-FX':
        obj.displayType = '100BASE-FX';
        break;
    case '100FX-S':
        obj.displayType = '100BASE-FX-S';
        break;
    case '100FX-M':
        obj.displayType = '100BASE-FX-M';
        break;
    case '1000Base-T':
        obj.displayType = '1000BASE-T';
        break;
    case '1000Base-SX':
        obj.displayType = '1000BASE-SX';
        break;
    case '1000Base-LX':
        obj.displayType = '1000BASE-LX';
        break;
    case '1000Base-GBIC':
        obj.displayType = '1000BASE GBIC';
        break;
    case '1000Base SFP':
        obj.displayType = '1000BASE SFP';
        break;
    case '1000Base-CX':
        obj.displayType = '1000BASE-CX';
        break;
    case '10GBASE-T' :
    case '10G':
    case '10GBASE XFP' :
    case '10GBASE SFP+' :
    default:
        obj.displayType = type;
        break;
  }

  /* for type module */
  switch (type)
  {
    /* SWCTRL_IS_100TX */
    case '100Base-TX':
    case '100BASE-TX':
        obj.speedDpxOpList = '10half?10full?100half?100full';
        obj.autonegStatusChecked = false;
        obj.autonegStatusDisabled = false;
        obj.autonegCapaSpeedArr = new Array("10h","10f","100h","100f");
        obj.autonegCapa10hDisabled = false;
        obj.autonegCapa10fDisabled = false;
        obj.autonegCapa100hDisabled = false;
        obj.autonegCapa100fDisabled = false;
        obj.autonegCapa1000hDisabled = true;
        obj.autonegCapa1000fDisabled = true;
        obj.autonegCapa10GhDisabled = true;
        obj.autonegCapa10GfDisabled = true;
        obj.autonegCapa40GhDisabled = true;
        obj.autonegCapa40GfDisabled = true;
        obj.autonegCapaSymDisabled = true;
        obj.autonegCapaFCDisabled = false;
        obj.rateLimitMax = 100000;
        obj.stormRateMax = 100000;
        obj.powerSaveStatusDisabled = true;
        break;

    /* SWCTRL_IS_100FIBER */
    case '100Base-FX':
    case '100FX-S':
    case '100FX-M':
    case '100BASE-FX':
    case 'FxSc single':
    case 'FxSc multi':
        obj.speedDpxOpList = '100full';
        obj.autonegStatusChecked = false;
        obj.autonegStatusDisabled = true;
        obj.autonegCapaSpeedArr= new Array("100f");
        obj.autonegCapa10hDisabled = true;
        obj.autonegCapa10fDisabled = true;
        obj.autonegCapa100hDisabled = true;
        obj.autonegCapa100fDisabled = false;
        obj.autonegCapa1000hDisabled = true;
        obj.autonegCapa1000fDisabled = true;
        obj.autonegCapa10GhDisabled = true;
        obj.autonegCapa10GfDisabled = true;
        obj.autonegCapa40GhDisabled = true;
        obj.autonegCapa40GfDisabled = true;
        obj.autonegCapaSymDisabled = true;
        obj.autonegCapaFCDisabled = true;
        obj.rateLimitMax = 100000;
        obj.stormRateMax = 100000;
        obj.powerSaveStatusDisabled = true;
        break;

    /* SWCTRL_IS_1000T */
    case '1000Base-T':
    case '1000BASE-T':
        if (cpntPortGigaphy == 1)
        {
          obj.speedDpxOpList = '10half?10full?100half?100full?1000full';
        }
        else
        {
          obj.speedDpxOpList = '10half?10full?100half?100full';
        }

        obj.autonegStatusChecked = false;
        obj.autonegStatusDisabled = false;
        obj.autonegCapaSpeedArr = new Array("10h","10f","100h","100f","1000f");
        obj.autonegCapa10hDisabled = false;;
        obj.autonegCapa10fDisabled = false;;
        obj.autonegCapa100hDisabled = false;;
        obj.autonegCapa100fDisabled = false;
        obj.autonegCapa1000hDisabled = true;;
        obj.autonegCapa1000fDisabled = false;;
        obj.autonegCapa10GhDisabled = true;
        obj.autonegCapa10GfDisabled = true;
        obj.autonegCapa40GhDisabled = true;
        obj.autonegCapa40GfDisabled = true;
        obj.autonegCapaSymDisabled = false;
        obj.autonegCapaFCDisabled = false;
        obj.rateLimitMax = 1000000;
        obj.stormRateMax = 1000000;
        obj.powerSaveStatusDisabled = false;
        break;

    /* SWCTRL_IS_1000FIBER */
    case '1000Base-SX':
    case '1000Base-LX':
    case '1000Base-GBIC':
    case '1000Base SFP':
    case '1000Base-CX':
    case '1000BASE-SX':
    case '1000BASE-LX':
    case '1000 GBIC':
    case '1000BASE SFP':
    case '1000BASE-CX':
        obj.speedDpxOpList = '1000full';
        obj.autonegStatusChecked = false;
        obj.autonegStatusDisabled = true;
        obj.autonegCapaSpeedArr = new Array("1000f");
        obj.autonegCapa10hDisabled = true;
        obj.autonegCapa10fDisabled = true;
        obj.autonegCapa100hDisabled = true;
        obj.autonegCapa100fDisabled = true;
        obj.autonegCapa1000hDisabled = true;
        obj.autonegCapa1000fDisabled = false;
        obj.autonegCapa10GhDisabled = true;
        obj.autonegCapa10GfDisabled = true;
        obj.autonegCapa40GhDisabled = true;
        obj.autonegCapa40GfDisabled = true;
        obj.autonegCapaSymDisabled = false;
        obj.autonegCapaFCDisabled = false;
        obj.rateLimitMax = 1000000;
        obj.stormRateMax = 1000000;
        obj.powerSaveStatusDisabled = true;
        break;

    /* SWCTRL_IS_10GCOPPER */
    case '10GBASE-T' :
        obj.speedDpxOpList = '10Gfull';
        obj.autonegStatusChecked = true;
        obj.autonegStatusDisabled = true;
        obj.autonegCapaSpeedArr = new Array("10Gf");
        obj.autonegCapa10hDisabled = true;
        obj.autonegCapa10fDisabled = true;
        obj.autonegCapa100hDisabled = true;
        obj.autonegCapa100fDisabled = true;
        obj.autonegCapa1000hDisabled = true;
        obj.autonegCapa1000fDisabled = true;
        obj.autonegCapa10GhDisabled = true;
        obj.autonegCapa10GfDisabled = false;
        obj.autonegCapa40GhDisabled = true;
        obj.autonegCapa40GfDisabled = true;
        obj.autonegCapaSymDisabled = false;
        obj.autonegCapaFCDisabled = false;
        obj.rateLimitMax = 10000000;
        obj.stormRateMax = 10000000;
        obj.powerSaveStatusDisabled = true;
        break;

    /* SWCTRL_IS_10GFIBER */
    case '10G':
    case '10GBASE':
    case '10GBASE XFP' :
    case '10GBASE SFP+' :
        obj.speedDpxOpList = '10Gfull';
        obj.autonegStatusChecked = false;
        obj.autonegStatusDisabled = true;
        obj.autonegCapaSpeedArr = new Array("10Gf");
        obj.autonegCapa10hDisabled = true;
        obj.autonegCapa10fDisabled = true;
        obj.autonegCapa100hDisabled = true;
        obj.autonegCapa100fDisabled = true;
        obj.autonegCapa1000hDisabled = true;
        obj.autonegCapa1000fDisabled = true;
        obj.autonegCapa10GhDisabled = true;
        obj.autonegCapa10GfDisabled = false;
        obj.autonegCapa40GhDisabled = true;
        obj.autonegCapa40GfDisabled = true;
        obj.autonegCapaSymDisabled = false;
        obj.autonegCapaFCDisabled = false;
        obj.rateLimitMax = 10000000;
        obj.stormRateMax = 10000000;
        obj.powerSaveStatusDisabled = true;
        break;

    /* SWCTRL_IS_40GFIBER */
    case '40GBASE QSFP':
        obj.speedDpxOpList = '40Gfull';
        obj.autonegStatusChecked = false;
        obj.autonegStatusDisabled = true;
        obj.autonegCapaSpeedArr = new Array("40Gf");
        obj.autonegCapa10hDisabled = true;
        obj.autonegCapa10fDisabled = true;
        obj.autonegCapa100hDisabled = true;
        obj.autonegCapa100fDisabled = true;
        obj.autonegCapa1000hDisabled = true;
        obj.autonegCapa1000fDisabled = true;
        obj.autonegCapa10GhDisabled = true;
        obj.autonegCapa10GfDisabled = true;
        obj.autonegCapa40GhDisabled = true;
        obj.autonegCapa40GfDisabled = false;
        obj.autonegCapaSymDisabled = false;
        obj.autonegCapaFCDisabled = false;
        obj.rateLimitMax = 40000000;
        obj.stormRateMax = 40000000;
        obj.powerSaveStatusDisabled = true;
        break;

    default:
        obj.speedDpxOpList = '';
        obj.autonegStatusChecked = false;
        obj.autonegStatusDisabled = true;
        obj.autonegCapaSpeedArr = new Array();
        obj.autonegCapa10hDisabled = true;
        obj.autonegCapa10fDisabled = true;
        obj.autonegCapa100hDisabled = true;
        obj.autonegCapa100fDisabled = true;
        obj.autonegCapa1000hDisabled = true;
        obj.autonegCapa1000fDisabled = true;
        obj.autonegCapa10GhDisabled = true;
        obj.autonegCapa10GfDisabled = true;
        obj.autonegCapa40GhDisabled = true;
        obj.autonegCapa40GfDisabled = true;
        obj.autonegCapaSymDisabled = true;
        obj.autonegCapaFCDisabled = true;
        obj.rateLimitMax = 0;
        obj.stormRateMax = 0;
        obj.powerSaveStatusDisabled = true;
        break;
  }

  return obj;
}

/* FUNCTION NAME: Esc2Str
 * PURPOSE: Convert HTML escaped string to normal string.
 * INPUT  : HTML escaped form string
 * OUTPUT : none
 * RETURN : normal form string.
 */
function Esc2Str(str)
{
  str = String(str);

  re = /&amp;/g;
  str = str.replace(re, "&");
  re = /&lt;/g;
  str = str.replace(re, "<");
  re = /&gt;/g;
  str = str.replace(re, ">");
  re = /&quot;/g;
  str = str.replace(re, "\"");
  re = /&#039;/g;
  str = str.replace(re, "\'");
  re = /&#092;/g;
  str = str.replace(re, "\\");

  return str;
}

/* FUNCTION NAME: Str2Esc
 * PURPOSE: Convert normal string to HTML escaped string.
 * INPUT  : normal form string
 * OUTPUT : none
 * RETURN : HTML escaped form string.
 */
function Str2Esc(str)
{
  str = String(str);

  re = /&/g;
  str = str.replace(re, "&amp;");
  re = /</g;
  str = str.replace(re, "&lt;");
  re = />/g;
  str = str.replace(re, "&gt;");
  re = /\"/g;
  str = str.replace(re, "&quot;");
  re = /\'/g;
  str = str.replace(re, "&#039;");
  re = /\\/g;
  str = str.replace(re, "&#092;");

  return str;
}

/* FUNCTION NAME: Quot2Esc
 * PURPOSE: replace char "\"" to escaped char "&quot;".
 * INPUT  : string.
 * OUTPUT : none
 * RETURN : escaped string.
 */
function Quot2Esc(str)
{
  re = /\"/g;
  str = String(str).replace(re, "&quot;");

  return str;
}

/* FUNCTION NAME: UrlEncoding
 * PURPOSE: Encoding the query string in URL, due to some special character will
 *          another purpose in URL. ex: \+, \&, \=.
 * INPUT  : String.
 * OUTPUT : None.
 * RETURN : Encoded string.
 */
function UrlEncoding(str)
{
  var inputString = Esc2Str(str).toString();
  var outputString = '';
  var n = 0;

  while (n < inputString.length)
  {
    var charChk = inputString.charAt(n);
    switch(true)
    {
      case ( ('a' <= charChk) && (charChk <= 'z') ):
      case ( ('A' <= charChk) && (charChk <= 'Z') ):
      case ( ('0' <= charChk) && (charChk <= '9') ):
          outputString += charChk;
          break;

      default:
          var charCode = inputString.charCodeAt(n);
          var hexVal = charCode.toString(16);
          outputString += '%' + ( hexVal.length < 2 ? '0' : '' ) + hexVal.toUpperCase();
          break;
    }
    n++;
  }

  return outputString;
}

/* FUNCTION NAME: PadLeft
 * PURPOSE: Add "0" to the left of a string utill the required length is reached.
 * INPUT  : string - input string.
 *          length - required length.
 * OUTPUT : None.
 * RETURN : string.
 */
function PadLeft(str, length)
{
  var count = length - str.length;
  var pad = '';

  while(count--)
  {
    pad += '0';
  }

  return pad + str;
}

/**
 * Valid format of data
 *
 * @param {object}     entry               - A data object.
 * @return {string}    'Internal error'    - If fail.
 * @return {string}    entry.error.message - If pass, and data is error message.
 * @return {undefined}                     - If pass, and data is not error message.
 */
function validData(entry) {
    if (typeof entry === 'undefined' ||
        (typeof entry.error !== 'undefined' && typeof entry.resultSet !== 'undefined') ||
        (typeof entry.error !== 'undefined') && typeof entry.error.message === 'undefined') {

        return 'Internal error';
    }

    if (typeof entry.error !== 'undefined') {
        return entry.error.message;
    }

    return undefined;
}

/**
 * Combine data form SSI to an option list.
 *
 * @param {object}         object         - A SSI data object.
 * @param {string}         key            - Keywords of data.
 * @param {string}         symbol         - Symbol to separate data. (Optional, default is '?')
 * @param {string}         conditionKey   - Keywords of specific condition. (Optional)
 * @param {string|number}  conditionValue - Value of specific condition. (Optional)
 * @return {string}        opList         - An option list.
 */
function getOptionListFromSsi(object, key, symbol, conditionKey, conditionValue) {
    var opList = '';
    var opListArr = [];
    var i;

    if (typeof symbol !== 'string') {
        symbol = '?';
    }

    if (typeof object.resultSet !== 'undefined') {
        for (i in object.resultSet) {
            if (typeof object.resultSet[i][key] === 'undefined') {
                continue;
            }

            if (conditionKey && conditionValue) {
                if (typeof object.resultSet[i][conditionKey] === 'undefined' ||
                        object.resultSet[i][conditionKey] != conditionValue) {
                    continue;
                }
            }

            opListArr.push(object.resultSet[i][key]);
        }
    }

    opList = opListArr.join(symbol);
    return opList;
}

/**
 * Check if object has these properties.
 * @param  {object}       obj           - A data object.
 * @param  {string|array} prop          - Properties.
 * @return {boolean}                    - True or false.
 */
function _hasOwnProperty(obj, prop) {
    /* for prop is array */
    if (Object.prototype.toString.call(prop) === '[object Array]') {
        for (var i in prop) {
            if (typeof obj[prop[i]] === 'undefined') {
                return false;
            }
        }

        return true;
    }
    /* for prop is string */
    else {
        if (typeof obj[prop] === 'undefined') {
            return false;
        }
        else {
            return true;
        }
    }
}

/**
 * If a selected data in list becomes unselected,
 * this function will also unselect the select all checkbox.
 *
 * @param {object}     obj           - Object whose checked is changed.
 * @param {number}     indexNum      - Part of ID of the select all checkbox.
 */
/* change all list check status */
function listChkChg (obj, indexNum) {
    var i;

    if (obj.checked == false) {
        for (i = 1; i <= indexNum; i++) {
            objChecked('allChk'+i, false);
        }
    }
}

/**
 * Get argument and return it in object format.
 * @param  {string}  query    - The argument of URL.
 * @return {object}  args     - Argument and its value.
 */
function getArgs(query) {
    var args = {};
    var pairs = query.split("&");

    for(var i = 0; i < pairs.length; i++) {
        var pos = pairs[i].indexOf('=');

        if (pos == -1) {
            continue;
        }

        var argname = pairs[i].substring(0, pos);
        var value = pairs[i].substring(pos + 1);
        value = decodeURIComponent(value);
        args[argname] = Str2Esc(value);
    }

    return args;
}

function js_object () {

    if (!(this instanceof js_object)) {
        return new js_object();
    }

    return this;
};

js_object.prototype.add = function () {
    var names = arguments[0],
        value = arguments[1],
        base = this;

    if (typeof names === "string") names = names.split(".");

    // If a value is given, remove the last name and keep it for later:
    var lastName = arguments.length === 2 ? names.pop() : false;

    // Walk the hierarchy, creating new objects where needed.
    // If the lastName was removed, then the last object is not set yet:
    for ( var i = 0; i < names.length; i++ ) {
        var a = /(.+)\[(\d+)\]$/.exec(names[i]);
        if (a) {
            base = base[ a[1] ] = base[ a[1] ] || [];
            base = base[ a[2] ] = base[ a[2] ] || {};
        }
        else {
            base = base[ names[i] ] = base[ names[i] ] || {};
        }
    }

    // If a value was given, set it to the last name:
    if ( lastName ) base = base[ lastName ] = value;

    return this;
};

js_object.prototype.cleanup = function () {
    for (var member in this) {
        if (typeof this[member] !== "function") {
            delete this[member];
        }
    }
    return this;
};

/**
 * Check if the string need to be abbreviated,
 * if yes, abbreviate it.
 * @param  {string}  checkStr    - Text string.
 * @param  {number}  strLen      - The visible length of checkStr.
 * @return {string}  output      - Output string.
 */
function abbreviateString(checkStr, strLen) {
    var output = '';
    var titleStr = '';
    var checkArr = [];

    checkArr = checkStr.split("<br />");

    for (var i = 0; i < checkArr.length; i++) {
        if (checkArr[i].length > strLen) {
            /* <abbr title='abcdef'> abc...</abbr>
             */
            output += "<abbr title='" + checkArr[i] + "'>" + checkArr[i].slice(0, strLen - 3) + "...</abbr>";
        }
        else {
            output += checkArr[i];
        }

        if (typeof checkArr[i+1] !== 'undefined') {
            output += "<br />";
        }
    }

    return output;
}

/*
function _I18N () {

    if (!(this instanceof _I18N)) {
        return new _I18N();
    }

    return this;
};

_I18N.prototype.set = function (text) {
    return text;
};

_I18N.prototype.get = function (text) {
    return text;
};

(function(window, top){

    var error = function () {
        if (console)
            console.log(arguments)
    };

    if (!top) {
        error('must have top');
    }

    if (!window.I18N) {
        window.I18N = _I18N();
    }

})(this, this.parent);
*/
